/** @file   smallwormai.cpp
 * @brief   Implementation of SmallWormAI class
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:44 $
 * @author  Tomi Lamminsaari
 */


#include "smallwormai.h" // class's header file
#include "www_assert.h"
#include "utils.h"
#include "warglobals.h"
using eng2d::Vec2D;

namespace WeWantWar {


// class constructor
SmallWormAI::SmallWormAI( GameObject* pAlien ) :
  AIController( pAlien, WarGlobals::pObjTable->pPlayer )
{
  AIController::m_attackRange = 200;
  WWW_ASSERT( WarGlobals::pObjTable->pPlayer != 0 );
  WWW_ASSERT( pAlien != 0 );
}

// class destructor
SmallWormAI::~SmallWormAI()
{

}



/** Controls the small worm
 */
void SmallWormAI::updateAI( bool seeTarget, float dist )
{
  this->setRandomMovement( (rand() % 20) + 5 );
  
  // If we're not reloaded yet, we continue moving randomly.
  if ( m_pObject->reloading() ) {
    return;
  }
  
  // If the player is close enough, we shoot.
  if ( this->withinAttackRange() == true ) {
    this->reset();
    this->shoot() = 1;
    this->setCounter( 50 );
  }
}

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: smallwormai.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:44  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:38+02  lamminsa
 * Initial revision
 *
 */
